// Drops.cpp: implementation of the CDrops class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "GrabIt.h"
#include "Drops.h"
#include <math.h>
#include "Mouse.h"


#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CDrops::CDrops()
{
	m_PreventSpam = FALSE ;
	m_NumValidItems = 0 ;
	m_NumValidUbers = 0 ;
}

CDrops::~CDrops()
{

}




int CDrops::GetRange(DWORD itemX, DWORD itemY)
{
	DWORD	deltaX, deltaY ;
	if ( m_PlayerX > itemX)
		deltaX = m_PlayerX - itemX ;
	else
		deltaX = itemX - m_PlayerX ;
	if ( m_PlayerY > itemY)
		deltaY = m_PlayerY - itemY ;
	else
		deltaY = itemY - m_PlayerY ;
	DWORD	sums = deltaX*deltaX + deltaY*deltaY ;
	return (int)sqrt( sums) ;
}


void CDrops::GetPosFromMem()
{
	HANDLE	m_diablo2_ph = GetProcessHandle("Diablo II", "Diablo II") ;

/*
// from mousepad to 1.09b
	DWORD man_unit = ReadProcessDWORD(m_diablo2_ph, 0x6FBC7578);
	DWORD man_pos = ReadProcessDWORD(m_diablo2_ph, man_unit+0x38);
	m_PlayerX = ReadProcessWORD(m_diablo2_ph, man_pos+0x02);
	m_PlayerY = ReadProcessWORD(m_diablo2_ph, man_pos+0x06);
*/
//from thohell on 11/23/01
	DWORD man_pos = ReadProcessDWORD(m_diablo2_ph, 0x6FBC63F8 ); 
	m_PlayerX = ReadProcessWORD(m_diablo2_ph, man_pos+0xb0); 
	m_PlayerY = ReadProcessWORD(m_diablo2_ph, man_pos+0xb4); 
}


int CDrops::GetClockPos(DWORD itemX, DWORD itemY)
{
	// compute the delta in the corrdinate and make the result positive
	int deltaY = itemY - m_PlayerY ;
	int deltaX = itemX - m_PlayerX ;
	if (deltaY <0) deltaY *= -1 ;
	if (deltaX <0) deltaX *= -1 ;

	// compute the angle in terms which will yeild a 1st quadrant result (0 to 90 degrees)
	double	opposite = (double)(deltaY/2);
	double	adjacent = (double)(deltaX/2);
	double	arctan = atan2(opposite, adjacent);
	const double PI = 3.14159265358979323846;
	double angle = ((arctan/PI*180));

	// convert the angle to the proper figure based on what quadrant it is in
	// upper right
	if ((itemY >= m_PlayerY) && (itemX >= m_PlayerX)) {
		angle = angle ;

	// lower right
	} else 	if ((itemY <= m_PlayerY) && (itemX >= m_PlayerX)) {
		angle = 360.0-angle ;

	// lower left
	} else 	if ((itemY <= m_PlayerY) && (itemX <= m_PlayerX)) {
		angle = 180.0+angle;

	// upper left
	} else 	if ((itemY >= m_PlayerY) && (itemX <= m_PlayerX)) {
		angle = 180.0-angle;

	} else {
		angle = angle;
	}


	// convert the angle to clock position based on game orientation (adjust by 45 degrees)
	if (angle <= 15.0)
		return	4 ;

	else if ((angle <= 45.0) && (angle > 15.0))
		return	5 ;

	else if ((angle <= 75.0) && (angle > 45.0))
		return	6 ;

	else if ((angle <= 105.0) && (angle > 75.0))
		return	7 ;

	else if ((angle <= 135.0) && (angle > 105.0))
		return	8 ;

	else if ((angle <= 165.0) && (angle > 135.0))
		return	9 ;

	else if ((angle <= 195.0) && (angle > 165.0))
		return	10 ;

	else if ((angle <= 225.0) && (angle > 195.0))
		return	11 ;

	else if ((angle <= 255.0) && (angle > 225.0))
		return	12 ;

	else if ((angle <= 285.0) && (angle > 255.0))
		return	1 ;

	else if ((angle <= 315.0) && (angle > 285.0))
		return	2 ;

	else if ((angle <= 345.0) && (angle > 315.0))
		return	3 ;

	else
		return	4 ;
}


// this function will be called on each movement packet to make sure items are with in range
void CDrops::UpdateRange(BOOL fromMovement)
{
	// delete stuff from lists here (need to see if we need to delete mem too)
	m_DropsValid.RemoveAll() ;
	m_PreventSpam = FALSE ;


	// if being called from the timer loop, then that means we have no items within range.
	//   however, this could be untrue so look at memory and see if we are where the  0x96
	//	 packet said we are
	if (!fromMovement) {
		GetPosFromMem() ;
	}


	CNormalDrop*	pItem ;
	CNormalDrop*	pItemToDelete ;
	POSITION		posPrimary ;
	POSITION		posItem = m_Drops.GetHeadPosition();
	for( posItem = m_Drops.GetHeadPosition(); (posPrimary = posItem) != NULL;) {
		// look for the first valid item which we haven't examined yet
		pItem = (CNormalDrop*)m_Drops.GetNext(posItem);

		// if no longer valid, then get rid of this waste of space
		if ( !pItem->m_Valid) {
			pItemToDelete = (CNormalDrop*)m_Drops.GetAt( posPrimary) ;

			m_Drops.RemoveAt( posPrimary) ;
			delete pItemToDelete ;
			continue ;
		}

		pItem->m_Range = GetRange( pItem->m_X, pItem->m_Y) ;


		// if its out of site, mark to be removed from our list
		if ( pItem->m_Range >= MIN_FORGET_RANGE) {

			// only take it off our list if this is from movement b/c we may not have
			//	gotten an update as to our XY pos if coming through a TP or WP
			if ( fromMovement) {
				pItem->m_Valid = FALSE ;
				pItem->m_BeenExamined = TRUE ;
				m_NumValidItems-- ;
			}


		// if its out of "grab" range, then pass over it and mark it as not examined
		} if ( pItem->m_Range > pItem->m_MaxRange) {
			if ( fromMovement) {
				pItem->m_BeenExamined = TRUE ;
			}

		// if its within range then add to the pickup list
		} else {
			CNormalDrop*	pItemRange ;
			POSITION		posCurrent ;
			BOOL			bInserted = FALSE ;

			pItem->m_BeenExamined = FALSE ;
			// we want the list to be sorted from closest to furthest
			POSITION posNext = m_DropsValid.GetHeadPosition();
			for( posNext = m_DropsValid.GetHeadPosition(); (posCurrent = posNext) != NULL;) {
				pItemRange = (CNormalDrop*)m_DropsValid.GetNext(posNext);

				// if this item is closer or as close as this item, insert
				if ( pItem->m_Range <= pItemRange->m_Range) {
					m_DropsValid.InsertBefore( posCurrent, pItem) ;
					bInserted = TRUE ;
					break ;
				}
			}

			// if we didn't insert, then add to tail
			if ( !bInserted) {
				m_DropsValid.AddTail( pItem) ;
			}
		}
	}
}


void CDrops::PickUpItem()
{
	if (m_DropsValid.IsEmpty())
		UpdateRange(FALSE) ;

	CNormalDrop*	pItem ;
	BOOL			gotOne = FALSE ;
	POSITION		posPrimary ;

	POSITION posItem = m_DropsValid.GetHeadPosition() ;
	for( posItem = m_DropsValid.GetHeadPosition(); (posPrimary = posItem) != NULL;) {
		// look for the first valid item which we haven't examined yet
		pItem = (CNormalDrop*)m_DropsValid.GetNext(posItem);

		// if its not valid, then remove it from the drop list (but not the master list)
		if (!pItem->m_Valid)
			m_DropsValid.RemoveAt( posPrimary) ;
		else if (!pItem->m_BeenExamined) {

			pItem->m_Range = GetRange( pItem->m_X, pItem->m_Y) ;

			// if we have already gotten one, get this one too if its within
			//   4 spaces (no movement required)
			if (gotOne) {
				if (pItem->m_Range <= 4) {
					SendPacketViaD2(sizeof(pItem->m_SendMsg), (unsigned char*)pItem->m_SendMsg);
					pItem->m_BeenExamined = TRUE ;
				} else
					break ;

			// if we haven't gotten one yet and its valid, make sure its within range
			} else if ( pItem->m_Range <= pItem->m_MaxRange) {
				// set the delay time if we want to freeze the action
				int iSleep = 0 ;
				m_PreventSpam = FALSE ;		// allow flood on short distances
				if ((pItem->m_Range > 5) /*&& (!pItem->m_BeenDelayed)*/) {
					iSleep = (pItem->m_Range)*m_LagPerYard ;
					m_DelayTime = iSleep ;		// no need to add to the uber penalty
					m_PreventSpam = TRUE ;		// anti-flood control

				// already been delayed, so don't delay again... but don't flood either!
//				} else if (pItem->m_BeenDelayed) {
//					m_PreventSpam = TRUE ;		// anti-flood control
				}

				// this will only work if the player remains still; we need to pause the
				//   game in order to force a pick up.
				SendPacketViaD2(sizeof(pItem->m_SendMsg), (unsigned char*)pItem->m_SendMsg);
				pItem->m_BeenExamined = TRUE ;
/*				pItem->m_FailCount++ ;

				// if we fail 20 times, then give up on this item!!!
				if (pItem->m_FailCount >= 10) {
					pItem->m_Valid = FALSE ;
//cn	PrintMessage( giving up on item ) ; - need the name :(
				}
*/
				if (iSleep > 0) {
					float fSleep = (float)iSleep/1000 ;
					char tmp[80] ;
					sprintf( tmp, "%1.2f freeze to grab item", fSleep) ;
					PrintMessage( tmp, m_ColorLag) ;

					// do the sleep time and set so we will NEVER lag again for this item
					Sleep(iSleep) ;
//					pItem->m_BeenDelayed = TRUE ;
				}

				// make sure we don't send a send command every 10th of a second!!!
				gotOne = TRUE ;

			// if there are items within range, this will clear the way so we can pick them up
			} else {
				pItem->m_BeenExamined = TRUE ;
			}

		}
	}


	// if we didn't get one, its b/c all have been examined.  set all to unexamined
	if (!gotOne) {
		// set all valid items to unexamined
		for( posItem = m_DropsValid.GetHeadPosition(); posItem != NULL;) {
			// look for the first valid item which we haven't examined yet
			pItem = (CNormalDrop*)m_DropsValid.GetNext(posItem);
			if (pItem->m_Valid) {
				pItem->m_BeenExamined = FALSE ;
			}
		}
	}
}


void CDrops::PickUpUber()
{
	CUberDrop*		pItem ;
	BOOL			gotOne = FALSE ;
	POSITION		posPrimary ;

	POSITION posItem = m_DropsUber.GetHeadPosition() ;
	for( posItem = m_DropsUber.GetHeadPosition(); (posPrimary = posItem) != NULL;) {
		// look for the first valid item which we haven't examined yet
		pItem = (CUberDrop*)m_DropsUber.GetNext(posItem);

		// decrement delay
		if (pItem->m_DelayRemaining > 0)
			pItem->m_DelayRemaining = pItem->m_DelayRemaining - 75 - m_DelayTime ;

		// if its not valid, then remove it from the drop list (but not the master list)
		if (!pItem->m_Valid) {
			m_DropsUber.RemoveAt( posPrimary) ;

		// if there is still some delay remaining, don't grab it yet
		} else if (pItem->m_DelayRemaining > 0) {
			// do nothing

		// not been examined, so do it!
		} else if (!pItem->m_BeenExamined) {

			pItem->m_Range = GetRange( pItem->m_X, pItem->m_Y) ;

			// if we have already gotten one, get this one too if its within
			//   4 spaves (no movement required)
			if (gotOne) {
				if (pItem->m_Range <= 4) {
					SendPacketViaD2(sizeof(pItem->m_SendMsg), (unsigned char*)pItem->m_SendMsg);
					pItem->m_BeenExamined = TRUE ;
				} else
					break ;

			// if we haven't gotten one yet and its valid, make sure its within range
			} else if ( pItem->m_Range <= pItem->m_MaxRange) {
				// set the delay time if we want to freeze the action
				int iSleep = 0 ;
				m_PreventSpam = FALSE ;		// allow flood on short distances
				if ((pItem->m_Range > 5) /*&& (!pItem->m_BeenDelayed)*/) {
					iSleep = (pItem->m_Range)*m_LagPerYard ;
					m_PreventSpam = TRUE ;		// anti-flood control

				// already been delayed, so don't delay again... but don't flood either!
//				} else if (pItem->m_BeenDelayed) {
//					m_PreventSpam = TRUE ;		// anti-flood control
				}

				// this will only work if the player remains still; we need to pause the
				//   game in order to force a pick up.
				SendPacketViaD2(sizeof(pItem->m_SendMsg), (unsigned char*)pItem->m_SendMsg);
				pItem->m_BeenExamined = TRUE ;
/*				pItem->m_FailCount++ ;

				// if we fail 20 times, then give up on this item!!!
				if (pItem->m_FailCount >= 10) {
					pItem->m_Valid = FALSE ;
//cn	PrintMessage( giving up on item ) ; - need the name :(
				}
*/
				if (iSleep > 0) {
					float fSleep = (float)iSleep/1000 ;
					char tmp[80] ;
					sprintf( tmp, "%1.2f freeze to grab item", fSleep) ;
					PrintMessage( tmp, m_ColorLag) ;

					// do the sleep time and set so we will NEVER lag again for this item
					Sleep(iSleep) ;
//					pItem->m_BeenDelayed = TRUE ;
				}

				// make sure we don't send a send command every 10th of a second!!!
				gotOne = TRUE ;

			// if there are items within range, this will clear the way so we can pick them up
			} else {
				pItem->m_BeenExamined = TRUE ;
			}

		}
	}


	// if we didn't get one, its b/c all have been examined.  set all to unexamined
	if (!gotOne) {
		// make sure we have good coordinates
		GetPosFromMem() ;

		// set all valid items to unexamined
		for( posItem = m_DropsUber.GetHeadPosition(); posItem != NULL;) {
			// look for the first valid item which we haven't examined yet
			pItem = (CUberDrop*)m_DropsUber.GetNext(posItem);
			if (pItem->m_Valid) {
				pItem->m_BeenExamined = FALSE ;
			}
		}
	}

	m_DelayTime = 0 ;
}
